*================================================================*
* SAS programmer: James Nguyen, USEPA                            *
*                                                                *
* Project: OP inhibition studies                                 *
*                                                                *
* Chemical: Fenamiphos                              *
*                                                                *
* Descriptions:                                                  *
*     - run the selected (Exponent) final models                 *
*     - perform regression diagnostics                           *
*     - calculated ki values from human vs. rat analysis         *
*                                                                *
* Date: March 2020                                               *
*===============================================================*;
option formdlim="=" ls=100 ps=100 nodate nonumber;

%include "C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Newcode\Diagnostics3.SAS";

libname EPA "C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\kapp data";


/****************************************************************************/
/* Final NLMIXED Model                                                      */
/****************************************************************************/

data Fenamiphos;
     set epa.Fenamiphos;
run;
proc sort data=Fenamiphos;
     by id;
run;

/*
ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\Fenamiphos - individual sample curves.resids.rtf" startpage=no;
%scatter_plot(chemical=Fenamiphos);
ods rtf close;
*/

*===> Human vs. Rat;

/* Model 3 had gradients above 0.001 and a negligible value for the untransformed gh2. Trying model 2 instead */

/* 
title "Human vs. Rat: final model 3";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_HR;
PROC NLMIXED data=Fenamiphos  method=firo tech=newrap lis=3 maxiter=20000;
      PARMS ha=0.3 hb=0.2
			ra=0.4 rb=0.2
			gh1=0.1 0.5 0.9 1.4 gh12=0.1 0.5 0.9 1.4 gh2=0.1 0.5 0.9 1.4
			gr1=0.1 0.5 0.9 1.4 gr12=0.1 0.5 0.9 1.4 gr2=0.1 0.5 0.9 1.4
			S2E=0.1 0.5 0.9 / best= 50;
			gha=gh1*gh1/100;
			ghab=gh1*gh12/100;
			ghb=gh12*gh12/100+gh2*gh2/100000;
			gra=gr1*gr1/100;
			grab=gr1*gr12/100;
			grb=gr12*gr12/100+gr2*gr2/100;
            rha=ha+uha;
			rra=ra+ura;
            rhb=hb+uhb;
			rrb=rb+urb;
            PRED2 = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-2 + H_I__M + rrb*Rat*1e-2 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);
      RANDOM  uha uhb ura urb ~ normal([0, 0, 0, 0],	[gha, 
												 		 ghab, ghb,
														 0,    	  0,   gra,
														 0,       0,   grab, grb]) SUBJECT=ID out=RandID_HR; 
	  ESTIMATE "human/rat" (ha/hb)/(ra/rb);
	  ESTIMATE 'human ki' (ha/hb);
      ESTIMATE 'rat ki' (ra/rb);
	  estimate "gha" gh1*gh1/100;
	  estimate "ghab" gh1*gh12/100;
	  estimate "ghb" gh12*gh12/100+gh2*gh2/100000;
	  estimate "gra" gr1*gr1/100;
	  estimate "grab" gr1*gr12/100;
	  estimate "grb" gr12*gr12/100+gr2*gr2/100;
	  id pred2;
	  Predict PRED2 out=Resid_HR;
run;

%let factor=0.001;


ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\Fenamiphos human-rat.resids.rtf" startpage=no;
%DiagnosticsHR(chemical=Fenamiphos, model=3)
ods rtf close;
*%Calculate_Ki(chemical=TerbufosOxonSulfoxide, Hadj=1e-4, Radj=1e-4);
*/

title "Human vs. Rat: final model 2";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_HR;
PROC NLMIXED data=Fenamiphos  method=firo tech=newrap lis=3 maxiter=20000;
      PARMS ha=0.3 hb=0.2
			ra=0.4 rb=0.2
			gh1=0.1 0.5 0.9 1.4 gh12=0.1 0.5 0.9 1.4 gh2=0.1 0.5 0.9 1.4
			S2E=0.1 0.5 0.9 / best= 50;
			gha=gh1*gh1/100;
			ghab=gh1*gh12/100;
			ghb=gh12*gh12/100+gh2*gh2/100;
            rha=ha+ua;
			rra=ra+ua;
            rhb=hb+ub;
			rrb=rb+ub;
            PRED2 = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-2 + H_I__M + rrb*Rat*1e-2 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);
      RANDOM  ua ub ~ normal([0, 0],	[gha, 
												 		 ghab, ghb]) SUBJECT=ID out=RandID_HR; 
	  ESTIMATE "human/rat" (ha/hb)/(ra/rb);
	  ESTIMATE 'human ki' (ha/hb);
      ESTIMATE 'rat ki' (ra/rb);
	  estimate "gha" gh1*gh1/100;
	  estimate "ghab" gh1*gh12/100;
	  estimate "ghb" gh12*gh12/100+gh2*gh2/100;
	  id pred2;
	  Predict PRED2 out=Resid_HR;
run;

%let factor=0.001;


ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\Fenamiphos human-rat.resids.rtf" startpage=no;
%DiagnosticsHR(chemical=Fenamiphos, model=2)
ods rtf close;


*===> Adult vs. Infant;

/*  Replace by model 2 since model 3 so far has not converged without issues. Original model 3 had impossible covariance matrix.  */
/*
title "final model 3 - Adult (>=10 yr) vs. Infant";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_AI;
PROC NLMIXED data=Fenamiphos(where=(Human=1))  tech=nrridg lis=3 maxiter=1000 method=firo;
      PARMS ada=0.1 0.5 0.9	adB1=0.1 0.5 0.9
			ia=0.1 0.5 0.9 iB1=0.1 0.5 0.9
			ga1=0.1 0.5 0.9	ga12=0.1 0.5 0.9	ga2=0.1 0.5 0.9
			gi1=0.1 0.5 0.9	gi12=0.1 0.5 0.9	gi2=0.1 0.5 0.9
			S2E=0.4 / best=50;
			gada=ga1*ga1/100;
			gadab=ga1*ga12/100;
			gadb=ga12*ga12/100+ga2*ga2;
			gia=gi1*gi1/100;
			giab=gi1*gi12/100;
			gib=gi12*gi12/100+gi2*gi2;
			adb=adb1*10;
			ib=ib1*10;
			rada=ada+uada;
			ria=ia+uia;
            radb=adB+uadb;
			rib=iB+uib;
            PRED2 = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-3 + H_I__M*adult + rib*1e-3*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-4);
      RANDOM  uada uadb uia uib ~ normal([0, 0, 0, 0],   [gada, 
														gadab, gadb, 
														0,    0,     gia, 
														0,    0,     giab,   gib]) SUBJECT=ID out=RandID_AI; 
	 ESTIMATE "Adult/Infant ki" (ada/(adb1*10))/(ia/(ib1*10));
	  ESTIMATE 'Adult ki' (ada/(adb1*10));
      ESTIMATE 'Infant ki' (ia/(ib1*10));
  	  estimate "gada" ga1*ga1/100;
	  estimate "gadab" ga1*ga12/100;
	  estimate "gadb" ga12*ga12/100+ga2*ga2;
  	  estimate "gia" gi1*gi1/100;
	  estimate "giab" gi1*gi12/100;
	  estimate "gib" gi12*gi12/100+gi2*gi2;
	  estimate "ib" ib1*10;
	  estimate "adb" adb1*10;
	  id pred2;
	   predict pred2 out=Resid_AI;
run;

%let factor=0.0001;


ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\Fenamiphos Adult-Infant.resids.rtf" startpage=no;
%DiagnosticsAI(chemical=Fenamiphos, model=3)
ods rtf close;
*/

title "final model 2 - Adult (>=10 yr) vs. Infant";

		ods output ParameterEstimates=parm_AI;
	 PROC NLMIXED data=Fenamiphos(where=(Human=1))  tech=nrridg lis=3 maxiter=1000 method=firo;
      PARMS ada=0.1 0.5 0.9	adB1=0.1 0.5 0.9
			ia=0.1 0.5 0.9 iB1=0.1 0.5 0.9
			ga1=0.1 0.5 0.9	ga12=0.1 0.5 0.9	ga2=0.1 0.5 0.9
			S2E=0.4 / best=50;
			gada=ga1*ga1/100;
			gadab=ga1*ga12/100;
			gadb=ga12*ga12/100+ga2*ga2;
			adb=adb1*10;
			ib=ib1*10;
			rada=ada+uha;
			ria=ia+uha;
            radb=adB+uhb;
			rib=iB+uhb;
            PRED2 = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-3 + H_I__M*adult + rib*1e-3*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-4);

     RANDOM  uha uhb ~ normal([0, 0],   [gada, 
														gadab, gadb]) SUBJECT=ID out=RandID_AI;
	 ESTIMATE "Adult/Infant ki" (ada/(adb1*10))/(ia/(ib1*10));
	  ESTIMATE 'Adult ki' (ada/(adb1*10));
      ESTIMATE 'Infant ki' (ia/(ib1*10));
	  estimate 'adb' adb1*10;
	  estimate 'ib' ib1*10; 
   	  estimate "gada" ga1*ga1/100;
	  estimate "gadab" ga1*ga12/100;
	  estimate "gadb" ga12*ga12/100+ga2*ga2;
	  id pred2;
	   predict pred2 out=Resid_AI;
run;

%let factor=0.0001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\Fenamiphos Adult-Infant.resids.rtf" startpage=no;
%DiagnosticsAI(chemical=Fenamiphos, model=2)
ods rtf close;

*===> Male vs. Female;

title "final model 2b - male vs. female";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_MF;
PROC NLMIXED data=Fenamiphos(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000 method=firo;
      PARMS ma=0.1 0.5 0.9 mb1= 0.1 0.5 0.9
			fa=0.1 0.5 0.9 fB1=0.1 0.5 0.9
			gh1=0.1 0.5 0.9 gh12=0.1 0.5 0.9 gh2=0.1 0.5 0.9
			S2E=0.4 / best=50;
			gha=gh1*gh1/100;
			ghab=gh1*gh12/10;
			ghb=gh12*gh12+gh2*gh2;
			mb=mb1*10;
			fb=fb1*10;
            rma=ma+uha;
			rfa=fa+uha;
            rmb=mB+uhb;
			rfb=fB+uhb;
           PRED2 = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-3 + H_I__M*male + rfb*female*1e-3 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-4);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_MF; 
	 ESTIMATE "male/female ki" (ma/(mb1*10))/(fa/(fb1*10));
	  ESTIMATE 'male ki' (ma/(mb1*10));
      ESTIMATE 'female ki' (fa/(fb1*10));
	  estimate 'mb' mb1*10;
	  estimate 'fb' fb1*10;
  	  estimate "gha" gh1*gh1/100;
	  estimate "ghab" gh1*gh12/10;
	  estimate "ghb" gh12*gh12+gh2*gh2;
	  id pred2;
	  predict pred2 out=Resid_MF;
run;

%let factor=0.0001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\Fenamiphos Male-Female.resids.rtf" startpage=no;
%DiagnosticsMF(chemical=Fenamiphos, model=2)
ods rtf close;


*===> Caucasian vs. Other Races;

title "Final model 2 - Caucasian vs. Other Race";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_CO;
PROC NLMIXED data=Fenamiphos(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
      PARMS ca=0.1 0.5 0.9 cb1=0.1 0.5 0.9
			ora=0.1 0.5 0.9 orB1=0.1 0.5 0.9
			gh1=0.1 0.5 0.9 gh12=0.1 0.5 0.9 gh2=0.1 0.5 0.9
			S2E=.4 / best=50;
			gha=gh1*gh1/100;
			ghab=gh1*gh12/100;
			ghb=gh12*gh12/100+gh2*gh2;
			cb=cb1*10;
			orb=orb1*10;
            rca=ca+uha;
			rora=ora+uha;
            rcb=cB+uhb;
			rorb=orB+uhb;
		PRED2 = (rca*H_I__M*caucasian + rora*H_I__M*otherrace)/(rcb*caucasian*1e-6 + H_I__M*caucasian + rorb*otherrace*1e-6 + H_I__M*otherrace);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-4);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_CO;
	 ESTIMATE "Caucasian/Other Race ki" (ca/(cb1*10))/(ora/(orb1*10));
	  ESTIMATE 'Caucasain ki' (ca/(cb1*10));
      ESTIMATE 'Other Race ki' (ora/(orb1*10));
	  estimate 'cb' cb1*10;
	  estimate 'orb' orb1*10;
  	  estimate "gha" gh1*gh1/100;
	  estimate "ghab" gh1*gh12/100;
	  estimate "ghb" gh12*gh12/100+gh2*gh2;
	  id pred2;
	  predict pred2 out=Resid_CO;
run;

%let factor=0.0001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\Fenamiphos Caucasian-Other Races.resids.rtf" startpage=no;
%DiagnosticsCO(chemical=Fenamiphos, model=2)
ods rtf close;

%resids